<?php
include('includes/header.php');

// Mostrar errores para debug (puedes quitar en producción)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    // Ruta absoluta para evitar problemas (ajusta si es necesario)
    $dbPath = __DIR__ . '/api/.db.db';
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("Error conexión DB: " . $e->getMessage());
}

$table_name = 'playlist';

$migration_error = '';
$success_message = '';
$affected_users = 0;
$show_confirmation = false;
$old_password = '';
$new_password = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $old_password = trim($_POST['old_password'] ?? '');
    $new_password = trim($_POST['new_password'] ?? '');

    if (isset($_POST['migrate_password'])) {
        if ($old_password === '') {
            $migration_error = "Debe ingresar la contraseña actual.";
        } elseif ($new_password === '') {
            $migration_error = "Debe ingresar la nueva contraseña.";
        } elseif ($old_password === $new_password) {
            $migration_error = "La nueva contraseña debe ser diferente a la actual.";
        } else {
            $stmt = $db->prepare("SELECT COUNT(*) as count FROM $table_name WHERE password = :old_password");
            $stmt->execute([':old_password' => $old_password]);
            $affected_users = (int)$stmt->fetchColumn();

            if ($affected_users > 0) {
                $show_confirmation = true;
            } else {
                $migration_error = "No se encontraron usuarios con la contraseña especificada.";
            }
        }
    } elseif (isset($_POST['confirm_migration'])) {
        if ($old_password === '' || $new_password === '') {
            $migration_error = "Contraseñas no pueden estar vacías.";
        } else {
            $stmt = $db->prepare("UPDATE $table_name SET password = :new_password WHERE password = :old_password");
            $stmt->execute([
                ':new_password' => $new_password,
                ':old_password' => $old_password
            ]);

            $updated_count = $stmt->rowCount();

            if ($updated_count > 0) {
                $success_message = "¡Migración completada con éxito! Se actualizaron $updated_count usuarios.";
                $old_password = '';
                $new_password = '';
                $show_confirmation = false;
            } else {
                $migration_error = "No se actualizaron usuarios. Verifique la contraseña antigua.";
            }
        }
    }
}
?>

<div class="col-md-8 mx-auto">
    <div class="card bg-dark text-white">
        <div class="card-header">
            <h2 class="text-center"><i class="fas fa-exchange-alt"></i> Migración Masiva de Contraseñas</h2>
        </div>
        <div class="card-body">
            <?php if ($migration_error): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($migration_error) ?>
                </div>
            <?php endif; ?>

            <?php if ($success_message): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?= htmlspecialchars($success_message) ?>
                </div>
                <div class="text-center mt-3">
                    <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-primary">
                        <i class="fas fa-redo"></i> Realizar otra migración
                    </a>
                </div>
            <?php elseif ($show_confirmation): ?>
                <div class="alert alert-warning">
                    <h4><i class="fas fa-exclamation-triangle"></i> Confirmar Migración</h4>
                    <p>Se actualizarán <strong><?= $affected_users ?></strong> usuarios con contraseña:</p>
                    <ul class="list-group bg-transparent">
                        <li class="list-group-item bg-dark text-white"><strong>Contraseña actual:</strong> <?= htmlspecialchars($old_password) ?></li>
                        <li class="list-group-item bg-dark text-white"><strong>Nueva contraseña:</strong> <?= htmlspecialchars($new_password) ?></li>
                    </ul>
                    <p class="mt-3 text-danger"><i class="fas fa-exclamation-circle"></i> Esta acción no se puede deshacer.</p>
                </div>
                <form method="post" id="migrationForm">
                    <input type="hidden" name="old_password" value="<?= htmlspecialchars($old_password) ?>">
                    <input type="hidden" name="new_password" value="<?= htmlspecialchars($new_password) ?>">
                    <div class="text-center mt-4">
                        <button type="submit" name="confirm_migration" class="btn btn-success btn-lg mr-3">
                            <i class="fas fa-check-circle"></i> Confirmar Cambios
                        </button>
                        <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-danger btn-lg">
                            <i class="fas fa-times-circle"></i> Cancelar
                        </a>
                    </div>
                </form>
            <?php else: ?>
                <form method="post" id="passwordMigrationForm">
                    <div class="form-group">
                        <label for="old_password"><i class="fas fa-key"></i> Contraseña Actual</label>
                        <input type="text" class="form-control" id="old_password" name="old_password" required
                               value="<?= htmlspecialchars($old_password) ?>"
                               placeholder="Contraseña que desea cambiar" autofocus>
                    </div>
                    <div class="form-group">
                        <label for="new_password"><i class="fas fa-key"></i> Nueva Contraseña</label>
                        <input type="text" class="form-control" id="new_password" name="new_password" required
                               value="<?= htmlspecialchars($new_password) ?>"
                               placeholder="Nueva contraseña para los usuarios">
                    </div>
                    <div class="text-center mt-4">
                        <button type="submit" name="migrate_password" class="btn btn-primary btn-lg">
                            <i class="fas fa-search"></i> Buscar Usuarios
                        </button>
                        <a href="<?= basename($_SERVER["SCRIPT_NAME"]) ?>" class="btn btn-secondary btn-lg ml-3">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.getElementById('migrationForm')?.addEventListener('submit', function(e) {
    if (!confirm('¿ESTÁ SEGURO QUE DESEA ACTUALIZAR LAS CONTRASEÑAS DE <?= $affected_users ?> USUARIOS?\n\nESTA ACCIÓN NO SE PUEDE DESHACER.')) {
        e.preventDefault();
    }
});
</script>

<?php
include('includes/footer.php');
?>
